/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// water turbulence effect by joltz0r 2013-07-04, improved 2013-07-07
// Altered
#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;           // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;           // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution;      // Replaced for VGHD by defines above. TheEmu.
// varying vec2 surfacePosition; // Replaced for VGHD by defines above. TheEmu.

#define MAX_ITER 11

void main( void ) {

	vec2 p = surfacePosition*8.0 - vec2(10.0);

	vec2  i = p;
	float c = 1.0;
	float inten = .05;

	for (int n = 0; n < MAX_ITER; n++) 
	{
		float t = time * (0.5 - (0.5 / float(n+1)));
		i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(t + i.x));
		c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));
	}

	c /= float(MAX_ITER);
	c = 1.5-sqrt(c);

	gl_FragColor = vec4(vec3(c*c*c*c), 1.0) + vec4(0.0, 0.3, 0.5, 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}